<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Bookmarks</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Bookmarks</h1>
				<xsl:call-template name="bookmarks"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="bookmarks">
	<table>
		<tr>
			<th>id</th>
			<th>bookmark</th>
			<th>created</th>
			<th>date</th>
			<th>title</th>
			<th>visits</th>
			<th>localpath</th>
			<th>url</th>
			<th>description</th>
		</tr>
		
		
		<xsl:for-each select="bookmark">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@bookmark"/></td>
				<td><xsl:value-of select="@created"/></td>
				<td><xsl:value-of select="@date"/></td>
				<td><xsl:value-of select="@title"/></td>
				<td><xsl:value-of select="@visits"/></td>
				<td><xsl:value-of select="localpath"/></td>
				<td><xsl:value-of select="url"/></td>
				<td><xsl:value-of select="description"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

